/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.generic.Interface;

import com.xiaoyue.tinkers_ingenuity.content.library.events.LivingCalculateAbsEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.events.TinkerToolCriticalEvent;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface ToolCombatHook {
    public static final ToolCombatHook EMPTY = new ToolCombatHook(){};

    default public void onCriticalHit(IToolStackView tool, TinkerToolCriticalEvent event, LivingEntity player, LivingEntity target, int level) {
    }

    default public void onDamageAbs(IToolStackView tool, LivingCalculateAbsEvent event, LivingEntity attacker, LivingEntity target, int level) {
    }

    default public void onKillTarget(IToolStackView tool, LivingDeathEvent event, LivingEntity attacker, LivingEntity target, int level) {
    }

    default public void onTakeDamage(IToolStackView tool, LivingDamageEvent event, DamageSource source, LivingEntity entity, int level) {
    }

    default public void onShieldBlocked(IToolStackView tool, ShieldBlockEvent event, Player player, DamageSource source, int level) {
    }

    public record AllMerge(Collection<ToolCombatHook> modules) implements ToolCombatHook
    {
        @Override
        public void onCriticalHit(IToolStackView tool, TinkerToolCriticalEvent event, LivingEntity player, LivingEntity target, int level) {
            for (ToolCombatHook module : this.modules) {
                module.onCriticalHit(tool, event, player, target, level);
            }
        }

        @Override
        public void onDamageAbs(IToolStackView tool, LivingCalculateAbsEvent event, LivingEntity attacker, LivingEntity target, int level) {
            for (ToolCombatHook module : this.modules) {
                module.onDamageAbs(tool, event, attacker, target, level);
            }
        }

        @Override
        public void onKillTarget(IToolStackView tool, LivingDeathEvent event, LivingEntity attacker, LivingEntity target, int level) {
            for (ToolCombatHook module : this.modules) {
                module.onKillTarget(tool, event, attacker, target, level);
            }
        }

        @Override
        public void onTakeDamage(IToolStackView tool, LivingDamageEvent event, DamageSource source, LivingEntity entity, int level) {
            for (ToolCombatHook module : this.modules) {
                module.onTakeDamage(tool, event, source, entity, level);
            }
        }

        @Override
        public void onShieldBlocked(IToolStackView tool, ShieldBlockEvent event, Player player, DamageSource source, int level) {
            for (ToolCombatHook module : this.modules) {
                module.onShieldBlocked(tool, event, player, source, level);
            }
        }
    }
}

